---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：28-Validate API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **REST APIエンドポイントパス**：RESTハンドラーのコード未精査

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/admin/indices/validate/query/TransportValidateQueryAction.java` - 実行ロジック
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/validate/query/ValidateQueryRequest.java` - リクエスト構造
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportBroadcastAction継承 | E-01 (80-84行目) | ○ |
| C-02 | SEARCHスレッドプールで実行 | E-01 (104行目) | ○ |
| C-03 | クエリリライト実行 | E-01 (113-139行目) | ○ |
| C-04 | IndexNotFoundExceptionの特別処理 | E-01 (117-118行目) | ○ |
| C-05 | all_shards=falseでランダムルーティング | E-01 (158-164行目) | ○ |
| C-06 | createValidationContext使用 | E-01 (233行目) | ○ |
| C-07 | toQuery + preProcess | E-01 (235-237行目) | ○ |
| C-08 | QueryShardException/ParsingExceptionキャッチ | E-01 (240-241行目) | ○ |
| C-09 | rewriteオプション対応 | E-01 (253-260行目) | ○ |
| C-10 | READレベルのクラスタブロックチェック | E-01 (170-172行目, 175-177行目) | ○ |
| C-11 | デフォルトクエリはMatchAllQueryBuilder | E-02 (62行目) | ○ |
| C-12 | valid判定はANDで集約 | E-01 (202行目) | ○ |
| C-13 | explain/rewrite/allShardsフラグ | E-01 (203行目), E-02 (64-66行目) | ○ |
| C-14 | REST APIエンドポイントパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- REST APIエンドポイント：RESTハンドラーの詳細コードを参照していない
  - 候補：RestValidateQueryAction.java（存在する場合）

## 5) リスクフラグ（レビュー観点）
- 0: REST APIパスの正確性

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIエンドポイントパスの正確性を確認
- [ ] all_shards=falseでのランダムルーティングの挙動を確認
